/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.io.cache;

import io.gitlab.jfronny.commons.io.JFiles;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;

public class FileBackedOperationResultCache {
    private final ConcurrentHashMap<String, Object> container = new ConcurrentHashMap();
    private final Path cacheDir;

    public FileBackedOperationResultCache(Path cacheDir) {
        this.cacheDir = cacheDir;
    }

    public void remove(String key) throws IOException {
        this.container.remove(key);
        Files.delete(this.cacheDir.resolve(key));
    }

    public void clear() throws IOException {
        this.container.clear();
        JFiles.clearDirectory(this.cacheDir);
    }

    public <T, TEx extends Throwable> T get(String key, ThrowingSupplier<T, TEx> builder, Type klazz) throws IOException, TEx {
        if (!this.container.containsKey(key)) {
            Path cd = this.cacheDir.resolve(key);
            if (Files.exists(cd, new LinkOption[0])) {
                Object value = JFiles.readObject(cd, klazz);
                JFiles.writeObject(cd, value);
                this.container.put(key, value);
            } else {
                this.container.put(key, builder.get());
            }
        }
        return (T)this.container.get(key);
    }
}

